const formAuthentication = document.querySelector('#formAuthentication');
document.addEventListener('DOMContentLoaded', function (e) {
  (function () {
    if (formAuthentication) {
      const fv = FormValidation.formValidation(formAuthentication, {
        fields: {
          username: {
            validators: {
              notEmpty: {
                message: 'Lütfen kullanıcı adınızı girin'
              },
              stringLength: {
                min: 6,
                message: 'Kullanıcı adı 6 karakterden fazla olmalıdır'
              }
            }
          },
          email: {
            validators: {
              notEmpty: {
                message: 'Lütfen e-postanızı girin'
              },
              emailAddress: {
                message: 'Lütfen geçerli bir e-posta adresi girin'
              }
            }
          },
          'email-username': {
            validators: {
              notEmpty: {
                message: 'Lütfen e-posta / kullanıcı adınızı girin'
              },
              stringLength: {
                min: 6,
                message: 'Kullanıcı adı 6 karakterden fazla olmalıdır'
              }
            }
          },
          password: {
            validators: {
              notEmpty: {
                message: 'Lütfen şifrenizi girin'
              },
              stringLength: {
                min: 6,
                message: 'Şifre 6 karakterden fazla olmalıdır'
              }
            }
          },
          'confirm-password': {
            validators: {
              notEmpty: {
                message: 'Lütfen şifrenizi doğrulayın'
              },
              identical: {
                compare: function () {
                  return formAuthentication.querySelector('[name="password"]').value;
                },
                message: 'Şifre ve doğrulaması aynı değil'
              },
              stringLength: {
                min: 6,
                message: 'Şifre 6 karakterden fazla olmalıdır'
              }
            }
          },
          terms: {
            validators: {
              notEmpty: {
                message: 'Lütfen şartlar ve koşulları kabul edin'
              }
            }
          }
        },
        plugins: {
          trigger: new FormValidation.plugins.Trigger(),
          bootstrap5: new FormValidation.plugins.Bootstrap5({
            eleValidClass: '',
            rowSelector: '.mb-6'
          }),
          submitButton: new FormValidation.plugins.SubmitButton(),
          defaultSubmit: new FormValidation.plugins.DefaultSubmit(),
          autoFocus: new FormValidation.plugins.AutoFocus()
        },
        init: instance => {
          instance.on('plugins.message.placed', function (e) {
            if (e.element.parentElement.classList.contains('input-group')) {
              e.element.parentElement.insertAdjacentElement('afterend', e.messageElement);
            }
          });
        }
      });
    }
    const numeralMask = document.querySelectorAll('.numeral-mask');
    if (numeralMask.length) {
      numeralMask.forEach(e => {
        new Cleave(e, {
          numeral: true
        });
      });
    }
  })();
});
