<?php
date_default_timezone_set('Europe/Istanbul');
setlocale(LC_TIME, 'tr_TR.UTF-8');
?>
<?php
function formatProvider($provider) {
  if ($provider == 'cc') {
    return 'Kredi Kartı';
  } else if ($provider == 'crypto') {
    return 'Crypto';
  } else if ($provider == 'papara') {
    return 'Papara';
  } else if ($provider == 'bank') {
    return 'Banka Hesabı';
  } else {
    return 'Bilinmiyor';
  }
}

function formatPrice($price) {
  return number_format($price, 2, ',', '.');
}
?>
<div class="layout-page">
  <div class="content-wrapper">
    <?php include 'layout/nav.php'; ?>
    <div class="container-xxl flex-grow-1 container-p-y">
      <div class="row">
        <div class="col-12">
          <div class="card">
            <h5 class="card-header">Ödeme Talepleri</h5>
            <div class="p-2">
              <button class="btn btn-danger" onclick="deleteAll()">Tümünü Sil</button>
  </div>
            <div class="table-responsive text-nowrap">
              <table class="table">
                <thead>
                  <tr>
                    <th>ID</th>
                    <th>Kullanıcı Adı / E-Posta</th>
                    <th>Miktar</th>
                    <th>Sağlayıcı</th>
                    <th>Durum</th>
                    <th>Tarih</th>
                    <th>Sil</th>
                  </tr>
                </thead>
                <tbody class="table-border-bottom-0">
                  <?php foreach ($db->fetchAll('SELECT * FROM req_payments WHERE isDeleted = 0 ORDER BY id DESC') as $log): ?>
                  <tr>
                    <td><?=$log['id'] ?></td>
                    <td><?=$log['username'] ?></td>
                    <td>
                      <?=formatPrice($log['amount']) ?>₺
                      <?php if ($log['status'] == 'pending'): ?>
                      <i onclick="approveRequest(<?=$log['id'] ?>)" style="font-size: 25px; color: green; cursor: pointer; margin-right: 10px;" class="tf-icons ti ti-check"></i>
                      <i onclick="deleteRequest(<?=$log['id'] ?>)" style="font-size: 25px; color: red; cursor: pointer; margin-right: 10px;" class="tf-icons ti ti-x"></i>
                      <?php endif; ?>
                    </td>
                    <td><?=formatProvider($log['provider']) ?></td>
                    <td><?=($log['status'] == 'pending' ? '<span class="badge bg-warning">Beklemede</span>' : ($log['status'] == 'approved' ? '<span class="badge bg-success">Onaylandı</span>' : '<span class="badge bg-danger">Reddedildi</span>')) ?></td>
                    <td><?=date('d.m.Y H:i:s', $log['date']) ?></td>
                    <td><i onclick="deleteRequest(<?=$log['id'] ?>, 1)" style="font-size: 25px; color: red; cursor: pointer;" class="tf-icons ti ti-x"></i></td>
                  </tr>
                  <?php endforeach; ?>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div> <!-- row-->

      <div class="content-backdrop fade"></div>
    </div>
  </div>
</div>
<!-- MODALS START -->
<?php include 'components/newScanModal.php'; ?>
<!-- MODALS END -->
<script>
  const approveRequest = async(id) => {
    Swal.fire({
      title: 'Onayla',
      text: 'Bu talebi onaylamak istediğinizden emin misiniz?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Evet',
      cancelButtonText: 'Vazgeç'
    }).then(async(result) => {
      if (result.isConfirmed) {
        const req = await fetch('', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            approve: true,
            id: id
          })
        })
        const res = await req.text()
        if (res == 'OK') {
          Swal.fire({
            icon: 'success',
            title: 'Talep onaylandı',
            showConfirmButton: false,
            timer: 2000
          })
          setTimeout(() => {
            location.reload()
          }, 2000)
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Talep onaylanamadı',
          })
        }
      }
    })
  }

  const deleteRequest = async(id, isPermament = false) => {
    Swal.fire({
      title: 'Sil',
      text: 'Bu talebi silmek istediğinizden emin misiniz?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Evet',
      cancelButtonText: 'Vazgeç'
    })
    .then(async(result) => {
      if (result.isConfirmed) {
        const req = await fetch('', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            delete: true,
            id,
            isPermament
          })
        })
        const res = await req.text()
        if (res == 'OK') {
          Swal.fire({
            icon: 'success',
            title: 'Talep silindi',
            showConfirmButton: false,
            timer: 2000
          })
          setTimeout(() => {
            window.location.reload()
          }, 2000)
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Talep silinemedi',
          })
        }
      }
    })
  }

  const deleteAll = async() => {
    Swal.fire({
      title: 'Tümünü Sil',
      text: 'Bütün talepleri silmek istediğinizden emin misiniz?',
      icon: 'warning',
      showCancelButton: true,
      confirmButtonColor: '#3085d6',
      cancelButtonColor: '#d33',
      confirmButtonText: 'Evet',
      cancelButtonText: 'Vazgeç'
    })
    .then(async(result) => {
      if (result.isConfirmed) {
        const req = await fetch('', {
          method: 'POST',
          headers: {
            'Content-Type': 'application/json'
          },
          body: JSON.stringify({
            deleteAll: true
          })
        })
        const res = await req.text()
        if (res == 'OK') {
          Swal.fire({
            icon: 'success',
            title: 'Talepler silindi',
            showConfirmButton: false,
            timer: 2000
          })
          setTimeout(() => {
            window.location.reload()
          }, 2000)
        } else {
          Swal.fire({
            icon: 'error',
            title: 'Talepler silinemedi',
          })
        }
      }
    })
  }
</script>
