<?php
include "inc/config.php";
checkAuth();

function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}
ini_set('display_errors', 1);
error_reporting(E_ALL);
?>

<?php include "inc/header.php"; ?>
<?php include "inc/sidebar.php"; ?>

<div class="container-fluid p-4">
  <h1>🏦 Banka Hesapları</h1>

  <table class="table table-dark table-striped mt-4">
    <thead>
      <tr>
        <th>ID</th>
        <th>Ad</th>
        <th>IBAN</th>
        <th>İşlem</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $stmt = $pdo->query("SELECT * FROM bank_accounts ORDER BY id DESC");
      while($row = $stmt->fetch(PDO::FETCH_ASSOC)):
      ?>
      <tr>
        <td><?= e($row['id']) ?></td>
        <td><?= e($row['name']) ?></td>
        <td><?= e($row['iban']) ?></td>
        <td>
          <a href="edit_bank.php?id=<?= e($row['id']) ?>" class="btn btn-sm btn-primary">Düzenle</a>
        </td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>

<?php include "inc/footer.php"; ?>
