<?php
include "inc/config.php";
checkAuth();
function e($string) { return htmlspecialchars($string, ENT_QUOTES, 'UTF-8'); }
ini_set('display_errors', 1);
error_reporting(E_ALL);

if(!isset($_GET['id'])){
    header("Location: banks.php");
    exit;
}

$id = (int)$_GET['id'];

// Form gönderilmişse güncelle
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'];
    $iban = $_POST['iban'];

    $stmt = $pdo->prepare("UPDATE bank_accounts SET name = ?, iban = ? WHERE id = ?");
    $stmt->execute([$name, $iban, $id]);

    header("Location: banks.php");
    exit;
}

// Mevcut veriyi al
$stmt = $pdo->prepare("SELECT * FROM bank_accounts WHERE id = ?");
$stmt->execute([$id]);
$bank = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$bank){
    echo "Banka hesabı bulunamadı.";
    exit;
}
?>

<?php include "inc/header.php"; ?>
<?php include "inc/sidebar.php"; ?>

<div class="container-fluid p-4">
  <h1>🖊️ Banka Hesabını Düzenle</h1>

  <form method="post" class="mt-4">
    <div class="mb-3">
      <label>Ad</label>
      <input type="text" name="name" class="form-control" value="<?= e($bank['name']) ?>" required>
    </div>
    <div class="mb-3">
      <label>IBAN</label>
      <input type="text" name="iban" class="form-control" value="<?= e($bank['iban']) ?>" required>
    </div>
    <button type="submit" class="btn btn-success">Güncelle</button>
    <a href="banks.php" class="btn btn-secondary">İptal</a>
  </form>
</div>

<?php include "inc/footer.php"; ?>
