<?php
include "inc/config.php";
checkAuth();
function e($string) { return htmlspecialchars($string, ENT_QUOTES, 'UTF-8'); }

if(!isset($_GET['id'])){
    header("Location: crypto.php");
    exit;
}

$id = (int)$_GET['id'];

// Form gönderilmişse güncelle
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $name = $_POST['name'];
    $shortName = $_POST['shortName'];
    $walletNo = $_POST['walletNo'];

    $stmt = $pdo->prepare("UPDATE crypto_accounts SET name = ?, shortName = ?, walletNo = ? WHERE id = ?");
    $stmt->execute([$name, $shortName, $walletNo, $id]);

    header("Location: crypto.php");
    exit;
}

// Mevcut veriyi al
$stmt = $pdo->prepare("SELECT * FROM crypto_accounts WHERE id = ?");
$stmt->execute([$id]);
$crypto = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$crypto){
    echo "Kripto hesabı bulunamadı.";
    exit;
}
?>

<?php include "inc/header.php"; ?>
<?php include "inc/sidebar.php"; ?>

<div class="container-fluid p-4">
  <h1>🖊️ Kripto Hesabını Düzenle</h1>

  <form method="post" class="mt-4">
    <div class="mb-3">
      <label>Ad</label>
      <input type="text" name="name" class="form-control" value="<?= e($crypto['name']) ?>" required>
    </div>
    <div class="mb-3">
      <label>Kısaltma</label>
      <input type="text" name="shortName" class="form-control" value="<?= e($crypto['shortName']) ?>" required>
    </div>
    <div class="mb-3">
      <label>Cüzdan</label>
      <input type="text" name="walletNo" class="form-control" value="<?= e($crypto['walletNo']) ?>" required>
    </div>
    <button type="submit" class="btn btn-success">Güncelle</button>
    <a href="crypto.php" class="btn btn-secondary">İptal</a>
  </form>
</div>

<?php include "inc/footer.php"; ?>
