<?php
include "inc/config.php";
checkAuth();
function e($string) { return htmlspecialchars($string, ENT_QUOTES, 'UTF-8'); }

if(!isset($_GET['id'])){
    header("Location: papara.php");
    exit;
}

$id = (int)$_GET['id'];

// Form gönderilmişse güncelle
if($_SERVER['REQUEST_METHOD'] === 'POST'){
    $no = $_POST['no'];
    $iban = $_POST['iban'];

    $stmt = $pdo->prepare("UPDATE papara_accounts SET no = ?, iban = ? WHERE id = ?");
    $stmt->execute([$no, $iban, $id]);

    header("Location: papara.php");
    exit;
}

// Mevcut veriyi al
$stmt = $pdo->prepare("SELECT * FROM papara_accounts WHERE id = ?");
$stmt->execute([$id]);
$account = $stmt->fetch(PDO::FETCH_ASSOC);

if(!$account){
    echo "Papara hesabı bulunamadı.";
    exit;
}
?>

<?php include "inc/header.php"; ?>
<?php include "inc/sidebar.php"; ?>

<div class="container-fluid p-4">
  <h1>🖊️ Papara Hesabını Düzenle</h1>

  <form method="post" class="mt-4">
    <div class="mb-3">
      <label>Sahip</label>
      <input type="text" name="no" class="form-control" value="<?= e($account['no']) ?>" required>
    </div>
    <div class="mb-3">
      <label>IBAN</label>
      <input type="text" name="iban" class="form-control" value="<?= e($account['iban']) ?>" required>
    </div>
    <button type="submit" class="btn btn-success">Güncelle</button>
    <a href="papara.php" class="btn btn-secondary">İptal</a>
  </form>
</div>

<?php include "inc/footer.php"; ?>
