<?php
// Config ve oturum kontrolü
include "inc/config.php";
checkAuth();

// e() fonksiyonu: güvenli HTML çıktısı
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Hata raporlamasını aç (gerekirse)
ini_set('display_errors', 1);
error_reporting(E_ALL);
?>

<?php include "inc/header.php"; ?>
<?php include "inc/sidebar.php"; ?>

<div class="container-fluid p-4">
  <h1>📱 Papara Hesapları</h1>

  <table class="table table-dark table-striped mt-4">
    <thead>
      <tr>
        <th>ID</th>
        <th>Sahip</th>
        <th>IBAN</th>
        <th>İşlem</th>
      </tr>
    </thead>
    <tbody>
      <?php
      $stmt = $pdo->query("SELECT * FROM papara_accounts ORDER BY id DESC");
      while($row = $stmt->fetch(PDO::FETCH_ASSOC)):
      ?>
      <tr>
        <td><?= e($row['id']) ?></td>
        <td><?= e($row['no']) ?></td>
        <td><?= e($row['iban']) ?></td>
        <td>
          <a href="edit_papara.php?id=<?= e($row['id']) ?>" class="btn btn-sm btn-primary">Düzenle</a>
        </td>
      </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>

<?php include "inc/footer.php"; ?>
