<?php
include "inc/config.php";
checkAuth();
require_once "inc/functions.php";

if(!function_exists('e')){
    function e($string) { return htmlspecialchars($string, ENT_QUOTES, 'UTF-8'); }
}
?>

<?php include "inc/header.php"; ?>
<?php include "inc/sidebar.php"; ?>

<div class="container-fluid p-4">
  <h1>💰 Ödeme Talepleri</h1>

  <table class="table table-dark table-striped mt-4">
    <thead>
      <tr>
        <th>ID</th>
        <th>Kullanıcı</th>
        <th>Tutar</th>
        <th>Yöntem</th>
        <th>Durum</th>
        <th>Tarih</th>
        <th>İşlem</th>
      </tr>
    </thead>
    <tbody id="paymentsTable">
      <?php
      $stmt = $pdo->query("SELECT * FROM req_payments ORDER BY id DESC");
      $payments = $stmt->fetchAll(PDO::FETCH_ASSOC);
      foreach($payments as $row):
      ?>
      <tr id="row-<?= e($row['id']) ?>">
        <td><?= e($row['id']) ?></td>
        <td><?= e($row['username']) ?></td>
        <td><?= e($row['amount']) ?> ₺</td>
        <td><?= e($row['provider']) ?></td>
        <td id="status-<?= e($row['id']) ?>"><?= e($row['status']) ?></td>
        <td><?= formatDate($row['date']) ?></td>
        <td>
          <button class="btn btn-success btn-sm approveBtn" data-id="<?= e($row['id']) ?>">Onayla</button>
          <button class="btn btn-danger btn-sm rejectBtn" data-id="<?= e($row['id']) ?>">Reddet</button>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
    $(".approveBtn").click(function(){
        let id = $(this).data("id");
        $.post("payments_action.php", { action: "approve", id: id }, function(response){
            $("#status-"+id).text("approved");
        });
    });

    $(".rejectBtn").click(function(){
        let id = $(this).data("id");
        $.post("payments_action.php", { action: "reject", id: id }, function(response){
            $("#status-"+id).text("deleted");
        });
    });
});
</script>

<?php include "inc/footer.php"; ?>
