<?php
include "inc/config.php";
checkAuth();

// e() fonksiyonu: güvenli HTML çıktısı
function e($string) {
    return htmlspecialchars($string, ENT_QUOTES, 'UTF-8');
}

// Hata raporlamasını aç (gerekirse)
ini_set('display_errors', 1);
error_reporting(E_ALL);
?>

<?php include "inc/header.php"; ?>
<?php include "inc/sidebar.php"; ?>

<div class="container-fluid p-4">
  <h1>⚙️ Ayarlar</h1>

  <?php
  if(isset($_POST['liveChatCode'])){
      $stmt = $pdo->prepare("UPDATE settings SET liveChatCode = ? WHERE id = 1");
      $stmt->execute([$_POST['liveChatCode']]);
      echo "<div class='alert alert-success'>Ayarlar güncellendi ✅</div>";
  }

  $settings = $pdo->query("SELECT * FROM settings WHERE id=1")->fetch(PDO::FETCH_ASSOC);
  ?>

  <form method="post">
    <div class="mb-3">
      <label>Canlı Destek Kodu</label>
      <textarea class="form-control" rows="6" name="liveChatCode"><?= e($settings['liveChatCode']) ?></textarea>
    </div>
    <button type="submit" class="btn btn-primary">Kaydet</button>
  </form>
</div>

<?php include "inc/footer.php"; ?>
