<div class="osp__container">
  <form id="PhoneRequestForm" method="post" action="/tr/Home/PhoneRequest">
    <input name="__RequestVerificationToken" type="hidden" value="cohNK85xCXrUxKK2SuJYNruUQk40ONokZbtuM3QD_rAejJNnQZqUNzBs0GX3Uc0pDfUw_olDBCzt4DjGyLIk-UvE8vHHO3EdZbA1dCZ_HDU1" />
    <div class="container">
      <div class="osp__registration">
        <img src="/Content/img/logo/logo_callRequests.webp" alt="Call's logo" />
        <p class="osp__first-text">Sizi Aramamızı İster Misiniz?</p>

        <div class="osp__step_1">
          <div class="d-flex pt-3 pb-5 justify-content-between">
            <button class="btn btn-primary btn-outline btn-rounded osp_step_btn" id="osp_step_1-btn" type="button">
              Üyeliğim var
            </button>
            <button class="btn btn-primary btn-outline btn-rounded osp_step_btn" id="osp_step_2-btn" type="button">
              Üye değilim
            </button>
          </div>
        </div>

        <div class="osp__step_2" style="display: none;">
          <p class="osp__second-text" id="osp__second-text"></p>
          <div class="osp__input-group">
            <input type="hidden" name="requestType" class="osp_input" />
            <input type="text" name="nameAndSurname" class="osp_input" placeholder="Ad Soyad" />
            <input type="number" name="phoneNumber" id="phoneNumber" class="osp_input" placeholder="Telefon Numaranız (en az 10 haneli)" />
            <select name="subject" id="discussSubject" class="osp_input" required="">
              <option value="" selected="" disabled="" hidden="">Lütfen Görüşmek İstediğiniz Konuyu Seçiniz</option>
              <option value="Finansal İşlemler">Finansal İşlemler</option>
              <option value="Teknik Sorun ve Bonus İşlemleri">Teknik Sorun ve Bonus İşlemleri</option>
              <option value="Genel Site Tanıtım">Genel Site Tanıtım</option>
            </select>

            <textarea type="text" name="not" class="osp_input" placeholder="Not"></textarea>
          </div>

          <button class="btn osp__back-btn" type="button" id="osp__back-btn">Geri</button>

          <button class="btn osp__third-text" id="osp__send-phone-request" type="submit" disabled="">
            <i class="fa fa-play"></i>

            Gönder
          </button>
        </div>
      </div>
    </div>
  </form>
</div>
<div class="modal custom-modal" id="phoneRequestSentModal" tabindex="-1" aria-labelledby="phoneRequestSentModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" style="text-align: left; margin: 0;">
          BİLGİ
        </h4>
      </div>
      <div class="modal-body text-center" style="margin-top: 22px; font-size: 16px;"></div>
      <div class="modal-footer" style="border-top: 0;">
        <button type="button" class="btn btn-primary btn-outline btn-rounded closeInfoModal" data-bs-dismiss="modal">Onay</button>
      </div>
    </div>
  </div>
</div>
<script>
  $(document).ready(function () {
    checkRequestSentModal();
    checkDisableSendButton();

    function showIfLoggedIn() {
      $(".osp__step_1").hide();
      $(".osp_input[name=requestType]").val(1);
      $(".osp_input[name=nameAndSurname]").hide();
      $(".osp_input[name=phoneNumber]").hide();
      $("#osp__second-text").html("L&#252;tfen iletmek istediğiniz notunuzu yazınız.");
      $(".osp__step_2").fadeIn();
    }

    $(".osp_step_btn").click(function () {
      if ($(this).attr("id") === "osp_step_1-btn") {
        if (`False` === "False") {
          window.location.href = "/tr/Security/LogOn?returnUrl=%2Ftr%2FHome%2FPhoneRequest";
        } else {
          showIfLoggedIn();
        }
      } else {
        $(".osp__step_1").hide();
        $(".osp_input[name=requestType]").val(2);
        $(".osp_input[name=nameAndSurname]").show();
        $(".osp_input[name=phoneNumber]").show();
        $(".osp_input[name=subject]").show();
        $("#osp__second-text").html("L&#252;tfen adınızı, soyadınızı, telefon numaranızı, g&#246;r&#252;şmek istediğiniz konuyu ve iletmek istediğiniz notu yazınız.");
        $(".osp__step_2").fadeIn();
      }
    });

    $("#osp__back-btn").click(function () {
      $("#PhoneRequestForm")[0].reset();
      $("#osp__send-phone-request").attr("disabled", "disabled");
      $(".osp__step_2").hide();
      $(".osp__step_1").fadeIn();
    });

    if (`False` === "True") {
      $("#osp_step_1-btn").click();
      $("#osp__back-btn").hide();
    }

    $("#osp__send-phone-request").click(function () {
      const sendBtn = $(this);
      sendBtn.attr("disabled", "disabled");
      $("#PhoneRequestForm").trigger("submit");
      setTimeout(function () {
        sendBtn.attr("disabled", false);
      }, 3000);
    });
  });

  function checkRequestSentModal() {
    const requestSentStatus = ``;
    const errorMessageCode = ``;
    const errorMobile = "";
    const errorSameMobileRequest = "";
    const errorForRegisteredUser = "";

    if (!requestSentStatus) return;

    if (requestSentStatus === "True") {
      const message =
        `tr` == "tr"
          ? "Talebiniz oluşturuldu.</br></br> Temsilcilerimiz 7/24 hizmet vermektedir. </br></br> İşlem sırasına göre mümkün olan en kısa sürede sizi arayacağız."
          : "Your request has been created.  </br></br> Our representatives are available 24/7. </br> </br> We will call you as soon as possible according to the queue.";

      $("#phoneRequestSentModal").find(".modal-body").append(`<b class="text-success d-block mt-2">${message}</b>`);
    } else if (errorMessageCode === "True") {
      const message = `tr` == "tr" ? "30 dakika içerisinde 1 kez aranma talebi oluşturabilirsiniz." : "You can create a call request once within 30 minutes.";

      $("#phoneRequestSentModal").find(".modal-body").append(`<b class="text-danger d-block mt-2">${message}</b>`);
    } else if (errorMobile === "True") {
      const message = "Telefon numarası yalnızca rakamlardan oluşmalıdır.";

      $("#phoneRequestSentModal").find(".modal-body").append(`<b class="text-danger d-block mt-2">${message}</b>`);
    } else if (errorSameMobileRequest === "True") {
      const message =
        `tr` == "tr" ? "Bu telefon numarasından istek zaten 30 dakikadan daha kısa bir süre önce gönderildi. Daha sonra tekrar deneyin." : "From that phone number, request is already sent less than 30 minutes ago. Try again later.";

      $("#phoneRequestSentModal").find(".modal-body").append(`<b class="text-danger d-block mt-2">${message}</b>`);
    } else if (errorForRegisteredUser === "True") {
      const message = `tr` == "tr" ? "Zaten 30 dakikadan daha kısa bir süre önce hesabınızdan istek gönderdiniz. Daha sonra tekrar deneyin." : "You have already sent request from your account less than 30 minutes ago. Try again later.";

      $("#phoneRequestSentModal").find(".modal-body").append(`<b class="text-danger d-block mt-2">${message}</b>`);
    } else {
      $("#phoneRequestSentModal").find(".modal-body").append(`<b class="text-danger d-block mt-2">Error</b>`);
    }

    $("#phoneRequestSentModal").show();
  }

  function checkDisableSendButton() {
    $(".osp_input, #discussSubject").on("input change", function () {
      const isUserLoggedIn = $(".osp_input[name=requestType]").val() === "1";
      const notField = $(".osp_input[name=not]").val().trim();
      const selectedSubject = $("#discussSubject").val();
      const phoneNumber = $("#phoneNumber").val();
      const phoneNumberDigits = phoneNumber.replace(/\D/g, "");

      if ((isUserLoggedIn || selectedSubject !== "") && notField.length > 0 && isOptionSelected(selectedSubject) && (isUserLoggedIn || phoneNumberDigits.length >= 10)) {
        $("#osp__send-phone-request").prop("disabled", false);
      } else if (!isUserLoggedIn && notField.length > 0 && validatePhoneNumber() && isOptionSelected(selectedSubject)) {
        $("#osp__send-phone-request").prop("disabled", false);
      } else {
        $("#osp__send-phone-request").prop("disabled", true);
      }
    });
  }

  function isOptionSelected(subject) {
    return subject === "Finansal İşlemler" || subject === "Teknik Sorun ve Bonus İşlemleri" || subject === "Genel Site Tanıtım";
  }
  function validatePhoneNumber() {
    const phoneNumber = $("#phoneNumber").val();
    const phoneNumberDigits = phoneNumber.replace(/\D/g, "");
    return phoneNumberDigits.length >= 10;
  }

  $(".closeInfoModal").on("click", function () {
    $("#phoneRequestSentModal").hide();
  });
</script>
