<?php if (isIncludingURL('?isLive=False')): ?>
<iframe id="ifmSportsbook" src="https://sport.skppsportsdigi.com/SportsBook/Home" frameborder="0" style="height: 3065px; width: 100%;"></iframe>
<?php else: ?>
<iframe id="ifmSportsbook" src="https://sport.skppsportsdigi.com/SportsBook/Home" frameborder="0" style="height: 1000px; width:100%;"></iframe>
<?php endif; ?>
<style type="text/css">
  .iOS12-tagged {
    margin: 0;
    padding: 0;
    border: 0;
    width: 1px !important;
    min-width: 100%;
  }

  html,
  body {
    width: 100% !important;
  }
</style>
<style>
  #betslipNotificationWrap {
    background-color: #181b2a;
    width: 48px;
    border-radius: 50%;
    height: 48px;
    position: absolute;
    bottom: 95px;
    right: 20px;
    position: fixed;
    text-align: center;
    cursor: pointer;
    box-shadow: 0 5px 5px rgba(0, 0, 0, 0.4);
  }

  #betslipNotificationWrap svg {
    fill: white;
    width: 30px;
    height: 30px;
    top: 50%;
    position: absolute;
    left: 50%;
    transform: translate(-50%, -50%);
  }

  .notification {
    width: 19px;
    height: 19px;
    border-radius: 50%;
    display: flex;
    justify-content: center;
    align-items: center;
    background: #ecb50d;
    position: absolute;
    top: 0%;
    right: -2%;
    font-weight: bold;
    color: black;
    font-size: 10px;
  }
</style>
<div id="betslipNotificationWrap" style="display: block;">
  <svg viewBox="0 0 126 126">
    <path
      d="M106.2 74.8l-.1-.5.1.5zM17.8 31.6l2.4 13.6 5-.9c.9-.2 1.9.5 2 1.4l.1.7c.2.9-.5 1.9-1.4 2l-5 .9 1.2 6.7 6.8 38.5.1.8V28l-10 1.8c-.7.1-1.3.9-1.2 1.8zM19.8 54.2l.1.5-.1-.5zM89 18H71.8c0 4.8-3.9 8.8-8.8 8.8s-8.8-3.9-8.8-8.8H37c-1.1 0-2 .9-2 2v17.2h6.3c1.2 0 2.2 1 2.2 2.2v.8c0 1.2-1 2.2-2.2 2.2H35V106c0 1.1.9 2 2 2h17.2c0-4.8 3.9-8.8 8.8-8.8s8.8 3.9 8.8 8.8H89c1.1 0 2-.9 2-2V42.4h-6.3c-1.2 0-2.2-1-2.2-2.2v-.8c0-1.2 1-2.2 2.2-2.2H91V20c-.1-1.1-.9-2-2-2zM65.4 39.4c0-1.2 1-2.2 2.2-2.2h8c1.2 0 2.2 1 2.2 2.2v.8c0 1.2-1 2.2-2.2 2.2h-8c-1.2 0-2.2-1-2.2-2.2v-.8zm-17.1 0c0-1.2 1-2.2 2.2-2.2h8c1.2 0 2.2 1 2.2 2.2v.8c0 1.2-1 2.2-2.2 2.2h-8c-1.2 0-2.2-1-2.2-2.2v-.8zM46.1 54H80v7.2H46.1V54zm0 14.1H80v7.2H46.1v-7.2zm0 14.2H80v7.2H46.1v-7.2zM108.2 94.7l-2.4-13.6-5 .9c-.9.2-1.9-.5-2-1.4l-.1-.7c-.2-.9.5-1.9 1.4-2l5-.9-1.2-6.7-6.8-38.5-.2-.8v67.3l10-1.8c.8-.1 1.4-.9 1.3-1.8z"
    ></path>
  </svg>

  <div class="notification">2</div>
</div>
<script>
  $(document).ready(function () {
    function iOSversion() {
      if (/iP(hone|od|ad)/.test(navigator.platform)) {
        // supports iOS 2.0 and later: <https://bit.ly/TJjs1V>
        var v = navigator.appVersion.match(/OS (\d+)_(\d+)_?(\d+)?/);
        return [parseInt(v[1], 10), parseInt(v[2], 10), parseInt(v[3] || 0, 10)];
      }
    }

    ver = iOSversion();

    if (ver) {
      console.log("IOS Version=", ver[0]);
      if (ver[0] == 12) {
        $("#ifmSportsbook").addClass("iOS12-tagged");
      }
    }
  });

  (function (el) {
    var $iframe = $(el);
    var winUrl = window.location.toString();
    var iframeSrc = $iframe.attr("src");
    if (winUrl.indexOf("#") > -1) {
      iframeSrc += winUrl.substring(winUrl.indexOf("#"));
    }
    $iframe.attr("src", iframeSrc);

    var betslipButton = document.getElementById("betslipNotificationWrap");

    if (betslipButton) {
      betslipButton.addEventListener("click", function () {
        document.getElementById("ifmSportsbook").contentWindow.postMessage(
          {
            type: "GMCMS:goToBetslip",
          },
          "*"
        );
      });
    } else {
      console.warn("There is no betslip button available!");
    }

    window.addEventListener("message", function (e) {
      console.info("event received", e.data);
      var data = e.data;
      if (data) {
        var type = data.type;
        var payload = data.payload;
        switch (type) {
          case "OMFE:setIFrameHeight": {
            if (payload > 0) {
              $iframe.height(payload);
            }
            break;
          }
          case "OMFE:showOverlay": {
            document.body.classList.add("OMFE-showOverlay");
            break;
          }
          case "OMFE:hideOverlay": {
            document.body.classList.remove("OMFE-showOverlay");
            break;
          }
          case "OMFE:goToRegister": {
            $("#sn-registration-modal").modal("show");
            break;
          }
          case "OMFE:goToLogin": {
            window.location.assign("/tr/Security/LogOn");
            break;
          }
          case "OMFE:betPlaced": {
            $(document).trigger("BALANCE_UPDATED");
            break;
          }
          case "OMFE:locationChanged": {
            if (!payload.basePath) {
              break;
            }
            history.replaceState(payload.state, "Sport", `${payload.basePath}/${payload.pathname}${payload.hash}`);
            if (payload.hash && payload.offset) {
              window.scrollTo({
                top: $iframe.offset().top + payload.offset,
              });
            }
            break;
          }
          case "OMFE:scrollTop": {
            window.scrollTo({
              top: 0,
            });
            break;
          }
          case "OMFE:updateBetslipSelectionsCount": {
            BetslipState.betslipEventsCount = payload.count;
            redrawBetslip();
            break;
          }
          case "OMFE:betslipInitialized": {
            BetslipState.betslipIsVisible = true;
            redrawBetslip();
            break;
          }
          case "OMFE:betslipDestroyed": {
            BetslipState.betslipIsVisible = false;
            redrawBetslip();
            break;
          }
          default: {
            console.log(type);
          }
        }
      }
    });

    let BetslipState = {
      betslipEventsCount: 0,
      betslipIsVisible: false,
    };

    function redrawBetslip() {
      $("#betslipNotificationWrap .notification").text(BetslipState.betslipEventsCount);

      if (BetslipState && BetslipState.betslipEventsCount > 0) {
        $("#betslipNotificationWrap").show();
      } else {
        $("#betslipNotificationWrap").hide();
      }
    }
  })("#ifmSportsbook");
</script>
