    <script>
      let allGamesContainer = [];
      let providersContainer = [];
      let gameData = [];
      let filteredGames = [];
      let requestIsAuthenticated = false;
      let newGame = [];
      let popularGame = [];

      let liveCasinoTableSortingData = [];
      $.ajax({
        type: "GET",
        dataType: "json",
        async: false,
        url: "/tr/LiveCasino/GetLiveCasinoTableSortingJson",
        data: "key=All",
        success: function (res) {
          liveCasinoTableSortingData = res;
        },
      });

      $(document).ready(function () {
        getAllProvider();
        getPopularGamesNew();

        $(".main-footer").hide();

        $(document).on("click", ".home__popular", function (e) {
          $("#login-modal").modal("show");

          e.preventDefault();
        });

        $(document).on("click", ".category-filter__link", function (e) {
          e.stopPropagation();

          $("#main__search-games").val("");
          $("#main__providers-dropdown .dropdown-toggle").text($(this).find(".category-name").text());

          if (!$(this).hasClass("all-providers")) {
            $(".category-filter__link").removeClass("active");
            $(".personal-category-filter__link").removeClass("active");
            $(this).addClass("active");
            $("#main__categories-dropdown").find(".dropdown-toggle").text("Tüm Oyunlar");
            showFilteredGamesContainer(true, $(this).find(".category-name").text());
          } else {
            $(".category-filter__link").removeClass("active");
            showFilteredGamesContainer(false, `En Yeni Oyunlar`);
          }

          filterGames($(this));
        });

        $(document).on("click", ".personal-category-filter__link", function (e) {
          e.stopPropagation();
          $("#main__search-games").val("");
          $("#main__categories-dropdown .dropdown-toggle").text($(this).find(".personal-category").text());
          if (!$(this).hasClass("all-games")) {
            $(".personal-category-filter__link").removeClass("active");
            $(".category-filter__link").removeClass("active");
            $("#main__providers-dropdown").find(".dropdown-toggle").text("Tüm sağlayıcılar");
            $(this).addClass("active");
            showFilteredGamesContainer(true, $(this).find(".personal-category").text());
          } else {
            $(".personal-category-filter__link").removeClass("active");
            showFilteredGamesContainer(false, "En Yeni Oyunlar");
          }

          filterGames($(this));
        });

        let typingTimer;
        $("#main__search-games").keyup(async function (e) {
          e.preventDefault();
          e.stopPropagation();

          $(".category-filter__link").removeClass("active");
          $("#main__providers-dropdown .dropdown-toggle").text("Tüm sağlayıcılar");

          let typedText = $(this).val().toLowerCase();

          clearTimeout(typingTimer);

          typingTimer = setTimeout(async function () {
            if (typedText && typedText.length > 3) {
              const res = await getAllGamesNew("", "0", typedText);
              filteredGames = res;

              showFilteredGamesContainer(true, typedText + "...");
            } else {
              showFilteredGamesContainer(false, `En Yeni Oyunlar`);
            }
            displayFilteredGames();
          }, 1000);
        });

        $(document).on("click", ".slot_play-button", function (e) {
          e.stopImmediatePropagation();
          e.preventDefault();

          if (requestIsAuthenticated) {
            window.open($(this).attr("href"), "", "width=" + 1070 + ", height=" + 720);
          } else {
            $("#login-modal").modal("show");
          }
        });
      });

      function getPopularGamesNew() {
        $.ajax({
          url: "/tr/LiveCasino/GetLiveCasinoTables",
          type: "GET",
          dataType: "json",
          async: true,
          success: function (res) {
            popularGame = orderByliveCasinoTableSortingData(Array.from(res));

            displayGames();
          },
        });
      }

      function showFilteredGamesContainer(status, title) {
        if (status) {
          $(".main__new-games-count").hide();
          $(".popular-games-container").hide();
          $("#main__new-games-container").hide();
          $("#main__filtered-games-container").show();
        } else {
          $(".main__new-games-count").show();
          $(".popular-games-container").show();
          $("#main__new-games-container").show();
          $("#main__filtered-games-container").hide();
        }

        $(".main__new-games-title").text(title);
      }
      
      function getAllProvider() {
        $.ajax({
          type: "GET",
          datatype: "json",
          url: "/tr/Home/GetAllProviders",
          success: function (data) {
            providersContainer = data;
            displayPrividers();
          },
        });
      }
      async function getAllGamesNew(category, providerId, searchText) {
        const result = await $.ajax({
          type: "GET",
          datatype: "json",
          data: "category=" + category + "&providerId=" + providerId + "&searchText=" + searchText,
          url: "/tr/Home/GetAllGamesNew",
          success: function (data) { },
        });
        return result;
      }

      async function getNewGames() {
        const result = await getAllGamesNew("Newgames", "0", "");
        if (result) {
          newGame = result;
          displayGames();
        }
      }
      async function getPopularGames() {
        const result = await getAllGamesNew("Mostpopular", "0", "");
        if (result) {
          popularGame = result;
          displayGames();
        }
      }

      function orderByliveCasinoTableSortingData(popularGame) {
        arrOrder = Array.from(liveCasinoTableSortingData);
        orderedArr = [];
        orderedArr = Array.from(popularGame);

        orderedArr.forEach((el) => {
          el.PositionId = undefined;
        });

        for (let i = 0; i < arrOrder.length; i++) {
          orderedArr = orderedArr.filter((j) => {
            if (arrOrder[i].GameID) {
              if (arrOrder[i].SlotPageID == j.SlotPageID && arrOrder[i].GameID.toLowerCase() == j.GameID.toLowerCase()) {
                j.PositionId = arrOrder[i].PositionId;
                j.providersPosition = arrOrder[i].providersPosition;
              }
            } else if (arrOrder[i].CategoryId) {
              if (arrOrder[i].SlotPageID == j.SlotPageID && arrOrder[i].CategoryId == j.CategoryId) {
                j.PositionId = arrOrder[i].PositionId;
                j.providersPosition = arrOrder[i].providersPosition;
              }
            } else if (arrOrder[i].SlotPageID) {
              if (arrOrder[i].SlotPageID == j.SlotPageID && j.PositionId == undefined) {
                j.PositionId = arrOrder[i].PositionId;
                j.providersPosition = arrOrder[i].providersPosition;
              }
            }

            if (i == arrOrder.length - 1 && j.PositionId == undefined) {
              j.PositionId = arrOrder.length + 1;
            }
            return j;
          });
        }

        orderedArr.sort((a, b) => a.PositionId - b.PositionId);

        return orderedArr;
      }

      function displayGames() {
        if (newGame.length > 0) {
          $("#main__new-games-container .row").html("");

          for (let i = 0; i < 6; i++) {
            const imageUrl = newGame[i].ImageName.startsWith("http") ? newGame[i].ImageName : "/Content/themes/v1/GameImages/" + newGame[i].ImageBase + "/" + newGame[i].ImageName;

            $("#main__new-games-container .row").append(`
					<div class="col-6 col-md-4 col-lg-2 mb-4 game-bottom-list-contaier__items">

						<div class="all-games-hover slots-hover game-bottom-list-design" style="display: none;">
							<div class="play_btn__container">
								<a data-id="${newGame[i].SlotPageID}"
									data-gameId="${newGame[i].ID}"
									data-name="${newGame[i].GameName}"
									page-name="${newGame[i].SlotPageName}"
									href="/tr/${newGame[i].RealUrl}"
									class="slot-button__play slot_play-button games_view "
								>
									<i class="fa fa-play-circle"></i>
								</a>
							</div>
						</div>

						<div class="main__games-item">
							<div class="all-games-images main__games-item-all-games" data-id="${imageUrl}" style="background-image:url('${imageUrl}') , url('/content/img/nophoto.jpg');">
                            </div>
						</div>
					</div>
				`);
          }
        }

        if (popularGame.length > 0) {
          $("#main__popular-games-container .row").html("");

          for (let i = 0; i < 30; i++) {
            const imageUrl = popularGame[i].ImageName.startsWith("http") ? popularGame[i].ImageName : "/Content/themes/v1/GameImages/" + popularGame[i].ImageBase + "/" + popularGame[i].ImageName;

            $("#main__popular-games-container-carousel").append(`
					<div class="mb-4 game-bottom-list-contaier__items item">
						<div class="all-games-hover slots-hover game-bottom-list-design" style="display: none;">
							<div class="play_btn__container">
								<a data-id="${popularGame[i].SlotPageID}"
									data-gameId="${popularGame[i].ID}"
									data-name="${popularGame[i].GameName}"
									page-name="${popularGame[i].SlotPageName}"
									href="/tr/${popularGame[i].RealUrl}"
									class="slot-button__play slot_play-button games_view "
								>
									<i class="fa fa-play-circle"></i>
								</a>
							</div>
						</div>
						<div class="main__games-item">
							<div class="all-games-images main__games-item-all-games" data-id="${imageUrl}" style="background-image:url('${imageUrl}') , url('/content/img/nophoto.jpg');">
							</div>
							<div class="main__popular-games-provider">${popularGame[i].SlotPageName}</div>
							<div class="main__popular-games-title">${popularGame[i].GameName}</div>
						</div>
					</div>
				`);
          }
        }

        $("#main__popular-games-container-carousel-loader").attr("style", "display: none !important");

        $("#main__popular-games-container-carousel").owlCarousel({
          loop: true,
          dots: false,
          dots: false,
          items: 5,
          responsive: {
            0: {
              items: 2,
            },
            578: {
              items: 3,
            },
            1000: {
              items: 5,
            },
          },
        });
      }

      function displayFilteredGames() {
        $("#main__filtered-games-container .row").html("");
        for (let i = 0; i < 12; i++) {
          if (filteredGames[i]) {
            const imageUrl = filteredGames[i].ImageName.startsWith("http") ? filteredGames[i].ImageName : "/Content/themes/v1/GameImages/" + filteredGames[i].ImageBase + "/" + filteredGames[i].ImageName;

            $("#main__filtered-games-container .row").append(`
					<div class="col-6 col-md-4 col-lg-2 mb-4 game-bottom-list-contaier__items">
						<div class="all-games-hover slots-hover game-bottom-list-design" style="display: none;">
							<div class="play_btn__container">
								<a data-id="${filteredGames[i].SlotPageID}"
									data-gameId="${filteredGames[i].ID}"
									data-name="${filteredGames[i].GameName}"
									page-name="${filteredGames[i].SlotPageName}"
									href="/tr/${filteredGames[i].RealUrl}"
									class="slot-button__play slot_play-button games_view "
								>
									<i class="fa fa-play-circle"></i>
								</a>
							</div>
						</div>
						<div class="main__games-item">
                            <div class="all-games-images main__games-item-all-games" style="background-image:url('${imageUrl}') , url('/content/img/nophoto.jpg');">
                            </div>

						</div>
					</div>
				`);
          }
        }

        if (filteredGames.length === 0) {
          $("#main__filtered-games-container .row").append(`
				<div class="col-12 text-center mt-2 mb-4">
					<span> 0 Sonu&#231; </span>
				</div>
			`);
        }
      }
      //src="/Content/themes/v1/ProviderImages/${p.imageUrl}" class="all-games-images"

      function displayPrividers() {
        $("#main__providers-dropdown ul").append(`
			<li>
				<div class="dropdown-item category-filter__link all-providers">
					<span class="category-name">${"Tüm Oyunlar"}</span>
				</div>
			</li>`);

        if (providersContainer) {
        //   providersContainer.forEach((p) => {
        //   $("#main__providers-dropdown ul").append(`
        //     <li>
        //       <div class="dropdown-item category-filter__link" data-id="${p.SlotPageID}">
        //         <img src="/Content/themes/v1/ProviderImages/${p.ImageUrl}" class="all-games-images"
        //           />
        //         <span class="category-name">${p.SlotPageName}</span>
        //         <span class="category-count">${p.Count}</span>
        //       </div>
        //     </li>
        //   `);
        // });
        }
      }

      async function filterGames(event) {
        if (event != "") {
          if (event.hasClass("ProvablyFair")) {
            const res = await getAllGamesNew("", "300", "");
            filteredGames = res;
            displayFilteredGames();
            return;
          }
          if (event.attr("data-action")) {
            const res = await getAllGamesNew(event.attr("data-action"), "0", "");

            filteredGames = res;
            displayFilteredGames();
            return;
          }
          if (event.attr("data-id")) {
            const res = await getAllGamesNew("", event.attr("data-id"), "");

            filteredGames = res;
            displayFilteredGames();
            return;
          }

          if (event.attr("data-parameter") === "IsNew") {
            const res = await getAllGamesNew(event.attr("data-parameter" === "IsNew"), "0", "");
            filteredGames = res;
            displayFilteredGames();
            return;
          }
          if (event.attr("slotdata-id")) {
            const res = await getAllGamesNew("", event.attr("slotdata-id"), "");
            filteredGames = res;
            displayFilteredGames();
            return;
          }
        }
      }

      $(document).ready(function () {
        setInterval(function () {
          $("#slider6_3_arr").click();
        }, 15000);

        setCookie("seka_dontshow", false, 1);
      });
      function getCookie(cname) {
        var name = cname + "=";
        var ca = document.cookie.split(";");
        for (var i = 0; i < ca.length; i++) {
          var c = ca[i];
          while (c.charAt(0) == " ") {
            c = c.substring(1);
          }
          if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
          }
        }
        return "";
      }

      function setCookie(cname, cvalue, exdays) {
        var d = new Date();
        d.setTime(d.getTime() + exdays * 24 * 60 * 60 * 1000);
        var expires = "expires=" + d.toUTCString();
        document.cookie = cname + "=" + cvalue + "; " + expires;
      }

    </script>